float4x4 matWorldViewProjection; 

texture tex0; 
texture tex1;
texture tex2; 

float time;
float2 texelsize; 
 
float ROCKET[64];

sampler2D tex_0 = sampler_state
{
	texture = (tex0);
	MipFilter = Point; MagFilter = Point; MinFilter = Point;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D tex_1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D tex_2 = sampler_state
{
	texture = (tex2);
	MipFilter = Point; MagFilter = Point; MinFilter = Point;
	AddressU = Wrap; AddressV = Wrap;
};


void vs_blit_quad(in float4 ipos : POSITION,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	ipos.xy *= 1.0000;
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y += texelsize.y/2.f;
	otex.xy = float2(itex.x, itex.y);
};

//pre pass
float4 ps_transform_1(in float2 tex : TEXCOORD0) : COLOR0
{
	
	float a =   tex2D(tex_0, tex).r;
	//tex += float2(ROCKET[16], ROCKET[17]);
	float b  = tex2D(tex_1, tex).r;
	
	float overlap = abs(a+b);
	
	//return overlap;
// float4(ROCKET[16], ROCKET[17], 0.f, 1.f);
	return float4(overlap, a,  b, 1.f);
	return tex2D(tex_1, tex);
}


float4 ps_feedback_motion(in float2 tex : TEXCOORD0) : COLOR0
{
	
	float p = tex2D(tex_0, float2(tex.x, tex.y)).r;
	float r = tex2D(tex_1, float2(tex.x, tex.y)).r;

	float4 pixel = tex2D(tex_2, tex);
	
	float  kernelsize = 1.f;
	int    samples = 4.f;
	float2 scalar = tex-.5f;
	float4 color = float4(0.f, 0.f, 0.f, 0.f);
	
	for(int i=0;i<samples;i++)
	{ 
		float2 sample = kernelsize*texelsize*float2(sin(i*6.26/samples), cos(i*6.26/samples));
		//float2 offset = 2*texelsize*float2(sin(scalar.y*45), cos(scalar.x*45));		
		float4 evaluate = tex2D(tex_2, 1-float2(tex+sample));
		color += evaluate/samples;
	} 
	
	if(color.r <= .3f && p <= .01f) return float4(0.f, 0.f, 0.f, 1.f);
	if(color.g <= .3f && r <= .01f) return float4(0.f, 0.f, 0.f, 1.f);
		
	return saturate(color);
}



float4 ps_feedback_motion_smokeish(in float2 tex : TEXCOORD0) : COLOR0
{
	
	float p = tex2D(tex_0, float2(tex.x, tex.y)).r;
	float r = tex2D(tex_1, float2(tex.x, tex.y)).r;

	float4 pixel = tex2D(tex_2, tex);
	
	float  kernelsize = 1.f;
	int    samples = 4.f;
	float2 scalar = tex-.5f;
	float4 color = float4(0.f, 0.f, 0.f, 0.f);
	
	for(int i=0;i<samples;i++)
	{ 
		float2 sample = kernelsize*texelsize*float2(sin(i*6.26/samples), cos(i*6.26/samples));
		float2 offset = 2*texelsize*float2(sin(scalar.y*45), cos(scalar.x*45));		
		float4 evaluate = tex2D(tex_2, 1-float2(tex+sample+offset));
		color += evaluate/samples;
	} 
	
	if(color.r <= .3f && p <= .01f) return float4(0.f, 0.f, 0.f, 1.f);
	if(color.g <= .3f && r <= .01f) return float4(0.f, 0.f, 0.f, 1.f);
		
	return saturate(color);
}
///////////////////////////////////////////////////////////////////////////

void vs_blit(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y += texelsize.y/2.f;
	otex = itex;
}

sampler2D target = sampler_state
{
	texture = (tex2);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};


float4 ps_composition(in float2 tex : TEXCOORD0) : COLOR0
{
	//float p =  tex2Dlod(target, float4(tex, 0.f, .5f) ).r;
	float p =  tex2D(target, tex ).r;

	
	
	float a =  tex2D(tex_1, 1-tex).r;
	float b =  tex2D(tex_0, (1-tex)).r;

	float sub = (a+(1-p.r));    //p.r; 
	float add =  p.r+b;
	
	if(sub<.7) sub = 0.f;  //very sketcy/ugly edge fix
	
//	return min(add, sub)-edgefix;
	
//	return sub;
	return (sub*add);//*sub*sub*add*add;
	return min(max(add+sub, .5), 1);
	
	//return sub-add;
	
	
	//magic
}

///////////////////////////////////////////////////////////////////////////

technique transform2D
{
	pass pre_pass
	{
		vertexshader  = compile vs_2_0 vs_blit_quad();
		pixelshader   = compile ps_2_0 ps_transform_1();
	}
	
	pass transform_2_blit
	{	
		vertexshader = compile vs_3_0 vs_blit_quad();
		pixelshader  = compile ps_3_0 ps_feedback_motion(); 
	}
	
	pass blit
	{
		vertexshader = compile vs_2_0 vs_blit();
		pixelshader  = compile ps_2_0 ps_composition();
	}
}
